﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Graphics;
using CashierCrisis.Managers;

namespace CashierCrisis.UserInterface
{
    public class ExitGameUI: UI
    {
        InputManager input;
        UIButton yesButton;
        UIButton noButton;
        UIText sureText;

        public ExitGameUI(Game game)
            : base(game)
        {
            FontManager fontManager = CashierGame.Instance.Services.GetService(typeof(FontManager)) as FontManager;
            SpriteFont font = fontManager.GetFont("Default");
            input = CashierGame.Instance.Services.GetService(typeof(InputManager)) as InputManager; ;
            
            yesButton = new UIButton("Yes", Color.Yellow);
            yesButton.Font = font;
            yesButton.Position = new Vector2(SceneManager.RightAlign,600);
            
            noButton = new UIButton("No", Color.Yellow);
            noButton.Font = font;
            noButton.Position = new Vector2(SceneManager.RightAlign - 100, 600);
            
            sureText = new UIText("Are you sure you want to exit?");
            sureText.Font = font;
            sureText.Position = new Vector2(SceneManager.RightAlign - 410,450);
            sureText.Active = false;
            
            AddWidget(yesButton);
            AddWidget(noButton);
            AddWidget(sureText);
        }

        public override void WidgetCallback(UIWidget widget)
        {
            if (widget == yesButton)
            {
                SceneManager.Game.Exit();
            }

            if (widget == noButton)
            {
                UIManager.SwapUserInterface("MainMenu");
            }
        }

        public override void Update(Microsoft.Xna.Framework.GameTime gameTime)
        {
            base.Update(gameTime);
           
            if(input.LeftButton())
            {
                NextWidget();
            }

            if (input.RightButton())
            {
                PreviousWidget();
            }

            if (input.ConfirmButton())
            {
                IButton button = (IButton)SelectedWidget();
                button.OnPressed();
            }

       
        }
    }
}
